/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.configuration.ProtectedConfigIndexService;
import com.floragunn.searchguard.internalauthtoken.InternalAuthTokenProvider;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.diag.DiagnosticContext;
import com.floragunn.signals.NoSuchTenantException;
import com.floragunn.signals.SignalsInitializationException;
import com.floragunn.signals.SignalsTenant;
import com.floragunn.signals.SignalsUnavailableException;
import com.floragunn.signals.accounts.AccountRegistry;
import com.floragunn.signals.settings.SignalsSettings;
import com.floragunn.signals.watch.Watch;
import com.floragunn.signals.watch.state.WatchState;
import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class Signals
extends AbstractLifecycleComponent {
    private static final Logger log = LogManager.getLogger(Signals.class);
    private final ComponentState componentState;
    private final SignalsSettings signalsSettings;
    private NodeEnvironment nodeEnvironment;
    private final Map<String, SignalsTenant> tenants = new ConcurrentHashMap<String, SignalsTenant>();
    private Set<String> configuredTenants;
    private Client client;
    private ClusterService clusterService;
    private NamedXContentRegistry xContentRegistry;
    private ScriptService scriptService;
    private InternalAuthTokenProvider internalAuthTokenProvider;
    private AccountRegistry accountRegistry;
    private InitializationState initState = InitializationState.INITIALIZING;
    private Exception initException;
    private Settings settings;
    private String nodeId;
    private Map<String, Exception> tenantInitErrors = new ConcurrentHashMap<String, Exception>();
    private DiagnosticContext diagnosticContext;
    private final SignalsSettings.ChangeListener settingsChangeListener = new SignalsSettings.ChangeListener(){

        @Override
        public void onChange() {
            Signals.this.internalAuthTokenProvider.setSigningKey(Signals.this.signalsSettings.getDynamicSettings().getInternalAuthTokenSigningKey());
            Signals.this.internalAuthTokenProvider.setEncryptionKey(Signals.this.signalsSettings.getDynamicSettings().getInternalAuthTokenEncryptionKey());
        }
    };

    public Signals(Settings settings, ComponentState componentState) {
        this.componentState = componentState;
        this.settings = settings;
        this.signalsSettings = new SignalsSettings(settings);
        this.signalsSettings.addChangeListener(this.settingsChangeListener);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, InternalAuthTokenProvider internalAuthTokenProvider, ProtectedConfigIndexService protectedConfigIndexService, DiagnosticContext diagnosticContext) {
        try {
            this.nodeId = nodeEnvironment.nodeId();
            if (!this.signalsSettings.getStaticSettings().isEnabled()) {
                this.initState = InitializationState.DISABLED;
                return Collections.emptyList();
            }
            this.client = client;
            this.clusterService = clusterService;
            this.nodeEnvironment = nodeEnvironment;
            this.xContentRegistry = xContentRegistry;
            this.scriptService = scriptService;
            this.internalAuthTokenProvider = internalAuthTokenProvider;
            this.diagnosticContext = diagnosticContext;
            this.createIndexes(protectedConfigIndexService);
            if (this.settings.getAsBoolean("searchguard.enterprise_modules_enabled", Boolean.valueOf(true)).booleanValue() && this.signalsSettings.getStaticSettings().isEnterpriseEnabled()) {
                this.initEnterpriseModules();
            }
            this.accountRegistry = new AccountRegistry(this.signalsSettings);
            return Collections.singletonList(this);
        }
        catch (Exception e) {
            this.initState = InitializationState.FAILED;
            this.initException = e;
            log.error("Error while initializing Signals", (Throwable)e);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    public SignalsTenant getTenant(User user) throws SignalsUnavailableException, NoSuchTenantException {
        if (user == null) {
            throw new IllegalArgumentException("No user specified");
        }
        return this.getTenant(user.getRequestedTenant());
    }

    public SignalsTenant getTenant(String name) throws SignalsUnavailableException, NoSuchTenantException {
        SignalsTenant result;
        this.checkInitState();
        if (name == null || name.length() == 0 || "_main".equals(name) || "SGS_GLOBAL_TENANT".equals(name)) {
            name = "_main";
        }
        if ((result = this.tenants.get(name)) != null) {
            return result;
        }
        Exception tenantInitError = this.tenantInitErrors.get(name);
        if (tenantInitError != null) {
            throw new SignalsUnavailableException("Tenant " + name + " failed to intialize", this.nodeId, null, tenantInitError);
        }
        throw new NoSuchTenantException(name);
    }

    private void createIndexes(ProtectedConfigIndexService protectedConfigIndexService) {
        SignalsSettings.SignalsStaticSettings.IndexNames indexNames = this.signalsSettings.getStaticSettings().getIndexNames();
        String[] allIndexes = new String[]{indexNames.getWatches(), indexNames.getWatchesState(), indexNames.getWatchesTriggerState(), indexNames.getAccounts(), indexNames.getSettings()};
        this.componentState.addPart(protectedConfigIndexService.createIndex(new ProtectedConfigIndexService.ConfigIndex(indexNames.getWatches()).mapping(Watch.getIndexMapping(), 2).mappingUpdate(0, Watch.getIndexMappingUpdate()).dependsOnIndices(allIndexes).onIndexReady(this::init)));
        this.componentState.addPart(protectedConfigIndexService.createIndex(new ProtectedConfigIndexService.ConfigIndex(indexNames.getWatchesState()).mapping(WatchState.getIndexMapping())));
        this.componentState.addPart(protectedConfigIndexService.createIndex(new ProtectedConfigIndexService.ConfigIndex(indexNames.getWatchesTriggerState())));
        this.componentState.addPart(protectedConfigIndexService.createIndex(new ProtectedConfigIndexService.ConfigIndex(indexNames.getAccounts())));
        this.componentState.addPart(protectedConfigIndexService.createIndex(new ProtectedConfigIndexService.ConfigIndex(indexNames.getSettings())));
    }

    private void checkInitState() throws SignalsUnavailableException {
        switch (this.initState) {
            case INITIALIZED: {
                return;
            }
            case DISABLED: {
                throw new SignalsUnavailableException("Signals is disabled", this.nodeId, this.initState);
            }
            case INITIALIZING: {
                if (this.initException != null) {
                    throw new SignalsUnavailableException("Signals encountered errors while initializing but is still trying to start up. Please try again later.", this.nodeId, this.initState, this.initException);
                }
                throw new SignalsUnavailableException("Signals is still initializing. Please try again later.", this.nodeId, this.initState);
            }
            case FAILED: {
                throw new SignalsUnavailableException("Signals failed to initialize on node " + this.nodeId + ". Please contact admin or check the ES logs.", this.nodeId, this.initState, this.initException);
            }
        }
    }

    private void createTenant(String name) {
        if ("SGS_GLOBAL_TENANT".equals(name)) {
            name = "_main";
        }
        ComponentState tenantState = this.componentState.getOrCreatePart("tenant", name);
        tenantState.setMandatory(false);
        try {
            SignalsTenant signalsTenant = SignalsTenant.create(name, this.client, this.clusterService, this.nodeEnvironment, this.scriptService, this.xContentRegistry, this.internalAuthTokenProvider, this.signalsSettings, this.accountRegistry, tenantState, this.diagnosticContext);
            this.tenants.put(name, signalsTenant);
            log.debug("Tenant {} created", (Object)name);
        }
        catch (Exception e) {
            log.error("Error while creating tenant " + name, (Throwable)e);
            this.tenantInitErrors.put(name, e);
            tenantState.setFailed((Throwable)e);
        }
    }

    private void deleteTenant(String name) throws SignalsUnavailableException, NoSuchTenantException {
        SignalsTenant tenant = this.getTenant(name);
        if (tenant != null) {
            tenant.delete();
            this.tenants.remove(name);
            log.debug("Tenant {} deleted", (Object)name);
        } else {
            log.debug("Trying to delete non-existing tenant {}", (Object)name);
        }
    }

    private synchronized void init(ProtectedConfigIndexService.FailureListener failureListener) {
        if (this.initState == InitializationState.INITIALIZED) {
            return;
        }
        try {
            log.info("Initializing Signals");
            this.componentState.setState(ComponentState.State.INITIALIZING, "reading_settings");
            this.signalsSettings.refresh(this.client);
            this.componentState.setState(ComponentState.State.INITIALIZING, "reading_accounts");
            this.accountRegistry.init(this.client);
            this.componentState.setState(ComponentState.State.INITIALIZING, "initializing_keys");
            if (this.signalsSettings.getDynamicSettings().getInternalAuthTokenSigningKey() != null) {
                this.internalAuthTokenProvider.setSigningKey(this.signalsSettings.getDynamicSettings().getInternalAuthTokenSigningKey());
            }
            if (this.signalsSettings.getDynamicSettings().getInternalAuthTokenEncryptionKey() != null) {
                this.internalAuthTokenProvider.setEncryptionKey(this.signalsSettings.getDynamicSettings().getInternalAuthTokenEncryptionKey());
            }
            if ((this.signalsSettings.getDynamicSettings().getInternalAuthTokenSigningKey() == null || this.signalsSettings.getDynamicSettings().getInternalAuthTokenEncryptionKey() == null) && this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
                log.info("Generating keys for internal auth token");
                Object signingKey = this.signalsSettings.getDynamicSettings().getInternalAuthTokenSigningKey();
                String encryptionKey = this.signalsSettings.getDynamicSettings().getInternalAuthTokenEncryptionKey();
                if (signingKey == null) {
                    signingKey = this.generateKey(512);
                }
                if (encryptionKey == null) {
                    encryptionKey = this.generateKey(256);
                }
                try {
                    this.signalsSettings.getDynamicSettings().update(this.client, SignalsSettings.DynamicSettings.INTERNAL_AUTH_TOKEN_SIGNING_KEY.getKey(), signingKey, SignalsSettings.DynamicSettings.INTERNAL_AUTH_TOKEN_ENCRYPTION_KEY.getKey(), encryptionKey);
                }
                catch (ConfigValidationException e) {
                    log.error("Could not init encryption keys. This should not happen", (Throwable)e);
                    throw new SignalsInitializationException("Could not init encryption keys. This should not happen", e);
                }
            }
            this.createSignalsLogIndex();
            this.componentState.setState(ComponentState.State.INITIALIZING, "creating_tenants");
            if (this.configuredTenants != null) {
                log.debug("Initializing tenant schedulers");
                for (String tenant : this.configuredTenants) {
                    this.createTenant(tenant);
                }
            }
            failureListener.onSuccess();
            this.initState = InitializationState.INITIALIZED;
            this.componentState.setInitialized();
        }
        catch (SignalsInitializationException e) {
            failureListener.onFailure((Exception)e);
            this.initState = InitializationState.FAILED;
            this.initException = e;
            this.componentState.setFailed((Throwable)e);
        }
    }

    private void createSignalsLogIndex() {
        String signalsLogIndex = this.signalsSettings.getDynamicSettings().getWatchLogIndex();
        if (!this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
            log.debug("Not checking signals_log index because local node is not master");
            return;
        }
        if (this.clusterService.state().getMetadata().componentTemplates().containsKey("signals_log_template")) {
            log.debug("Template signals_log_template does already exist.");
            return;
        }
        if (signalsLogIndex.startsWith("<") && signalsLogIndex.endsWith(">")) {
            signalsLogIndex = signalsLogIndex.substring(1, signalsLogIndex.length() - 1).replaceAll("\\{.*\\}", "*");
        }
        if (!signalsLogIndex.startsWith(".")) {
            log.debug("signals log index does not start with ., so we do not need to create a template");
            return;
        }
        log.debug("Creating signals_log_template for {}", (Object)signalsLogIndex);
        PutComposableIndexTemplateAction.Request putRequest = new PutComposableIndexTemplateAction.Request("signals_log_template");
        putRequest.indexTemplate(new ComposableIndexTemplate((List)ImmutableList.of((Object)signalsLogIndex), new Template(Settings.builder().put("index.hidden", true).build(), null, null), null, null, null, null));
        this.client.execute((ActionType)PutComposableIndexTemplateAction.INSTANCE, (ActionRequest)putRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse response) {
                log.debug("Created signals_log_template");
            }

            public void onFailure(Exception e) {
                Signals.this.componentState.addLastException("create_signals_log_template", (Throwable)e);
                log.error("Error while creating signals_log_template", (Throwable)e);
            }
        });
    }

    synchronized void updateTenants(Set<String> configuredTenants) {
        configuredTenants = new HashSet<String>(configuredTenants);
        configuredTenants.add("_main");
        configuredTenants.remove("SGS_GLOBAL_TENANT");
        if (this.initState == InitializationState.INITIALIZED) {
            Set<String> currentTenants = this.tenants.keySet();
            for (String tenantToBeDeleted : Sets.difference(currentTenants, configuredTenants)) {
                try {
                    this.deleteTenant(tenantToBeDeleted);
                }
                catch (NoSuchTenantException e) {
                    log.debug("Tenant to be deleted does not exist", (Throwable)e);
                }
                catch (Exception e) {
                    log.error("Error while deleting tenant", (Throwable)e);
                }
            }
            for (String tenantToBeCreated : Sets.difference(configuredTenants, currentTenants)) {
                this.createTenant(tenantToBeCreated);
            }
        } else {
            this.configuredTenants = configuredTenants;
        }
    }

    private String generateKey(int bits) {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[bits / 8];
        random.nextBytes(bytes);
        return BaseEncoding.base64().encode(bytes);
    }

    private void initEnterpriseModules() throws SignalsInitializationException {
        Class<?> signalsEnterpriseFeatures;
        try {
            signalsEnterpriseFeatures = Class.forName("com.floragunn.signals.enterprise.SignalsEnterpriseFeatures");
        }
        catch (ClassNotFoundException e) {
            throw new SignalsInitializationException("Signals enterprise features not found", e);
        }
        try {
            signalsEnterpriseFeatures.getDeclaredMethod("init", new Class[0]).invoke(null, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new SignalsInitializationException("Error while initializing Signals enterprise features", e.getTargetException());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new SignalsInitializationException("Error while initializing Signals enterprise features", e);
        }
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
    }

    public AccountRegistry getAccountRegistry() {
        return this.accountRegistry;
    }

    public SignalsSettings getSignalsSettings() {
        return this.signalsSettings;
    }

    synchronized void setInitException(Exception e) {
        if (this.initException != null) {
            return;
        }
        this.initException = e;
        this.initState = InitializationState.FAILED;
    }

    public static enum InitializationState {
        INITIALIZING,
        INITIALIZED,
        FAILED,
        DISABLED;

    }
}

